﻿using System;

class Program
{
    static void Main(string[] args)
    {
        KFZ auto1 = new Auto();
        Auto auto2 = new Auto();
        KFZ auto3 = new KFZ();
        KFZ motorrad = new Motorrad();

        Console.WriteLine(auto1.GetType());
        Console.WriteLine(motorrad.GetType());

        if (auto1 is Auto)
            Console.WriteLine("Ja das ist ein Auto!");

        if (auto2 is KFZ)
            Console.WriteLine("Ja das gehört zu den KFZ!");

        if (auto3 is Auto)
            Console.WriteLine("Auto3 ist nur ein KFZ - dies sollte nicht erscheinen!");
        else
            Console.WriteLine("Ja das ist nur ein KFZ und kein Auto!");

        if (!(motorrad is Auto))
            Console.WriteLine("Ja das ist kein Auto!");

        //Allgemeiner geht immer
        KFZ kfz = auto2 as KFZ;
        kfz.Reifen = 4;

        //Spezieller nicht - as würde NULL liefern - daher benutzen wir ?? um dies abzufangen
        Auto auto = auto3 as Auto;
        //Auto auto = auto3 as Auto ?? new Auto();

        if (auto == null)
            Console.WriteLine("Wäre null!");
        else //dies würde nicht gehen wenn auto = null ist!
        {
            Console.WriteLine("Wäre nicht null!");
            auto.Schiebedach = true;
        }

        Console.Read();
    }
}

class KFZ
{
    int reifen;

    //Eigenschaften
    public int Reifen
    {
        get { return reifen; }
        set { reifen = value; }
    }

    int ps;

    public int Ps
    {
        get { return ps; }
        set { ps = value; }
    }

    int sitze;

    public int Sitze
    {
        get { return sitze; }
        set { sitze = value; }
    }

    public override string ToString()
    {
        return "Ich bin ein KFZ.";
    }
}

class Auto : KFZ
{
    bool schiebedach;

    public bool Schiebedach
    {
        get { return schiebedach; }
        set { schiebedach = value; }
    }

    public override string ToString()
    {
        return "Ich bin ein Auto.";
    }
}

class Motorrad : KFZ
{
    bool helmpflicht;

    public bool Helmpflicht
    {
        get { return helmpflicht; }
        set { helmpflicht = value; }
    }

    public override string ToString()
    {
        return "Ich bin ein Motorrad";
    }
}